#################################################################################################
#################################################################################################
#################################################################################################

# IMPORTANT!!!! CHANGE THE "source" command below if you want to run the simulation!
# The file "functions.R", which must be sourced, is in the same folder as the current file.

rm(list = ls())
library(ctqr)
library(DArq)
library(quantreg)
source(".../functions.R") # Insert correct path here
B <- 1000
tau <- c(0.1,0.25,0.75,0.9)

#################################################################################################
#################################################################################################
#################################################################################################

# Note 1: the actual time-to-event is typycally between 0 and 20.
# Note 2: the first-step is defined by pchreg(formula, breaks = 10, splinex = NULL)

# Simulation 1: the time between visits is an Exp(2) variable
set.seed(1234); S1 <- simulator(sim1, n = 250, B = B, tau = tau, lambda = 2)
set.seed(1234); T1 <- simulator(sim1, n = 500, B = B, tau = tau, lambda = 2)

# Simulation 2: the time between visits is an Exp(1) variable
set.seed(1234); S2 <- simulator(sim1, n = 250, B = B, tau = tau, lambda = 1)
set.seed(1234); T2 <- simulator(sim1, n = 500, B = B, tau = tau, lambda = 1)


S1
T1
S2
T2

#################################################################################################
#################################################################################################
# Some checks ###################################################################################
#################################################################################################
#################################################################################################

s <- T1 # replace S1,T1,S2,T2
par(mfrow = c(2,2))

plot(s, which = "icqr", var = 0)
plot(s, which = "icqr", var = 1)
plot(s, which = "icqr", var = 2)
plot(s, which = "icqr", var = 3)

plot(s, which = "ZFD", var = 0)
plot(s, which = "ZFD", var = 1)
plot(s, which = "ZFD", var = 2)
plot(s, which = "ZFD", var = 3)

plot(s, which = "YNH", var = 0)
plot(s, which = "YNH", var = 1)
plot(s, which = "YNH", var = 2)
plot(s, which = "YNH", var = 3)

# Checking estimated standard errors of icqr

plot(s, which = "icqr", var = 0, what = "se")
plot(s, which = "icqr", var = 1, what = "se")
plot(s, which = "icqr", var = 2, what = "se")
plot(s, which = "icqr", var = 3, what = "se")

# Checking times

par(mfrow = c(1,3))
for(j in 1:3){hist(S1$time[[j]], main = paste0(names(S1$time)[j], " --- mean =", round(mean(S1$time[[j]]),3)))}
for(j in 1:3){hist(T1$time[[j]], main = paste0(names(T1$time)[j], " --- mean =", round(mean(T1$time[[j]]),3)))}
for(j in 1:3){hist(S2$time[[j]], main = paste0(names(S2$time)[j], " --- mean =", round(mean(S2$time[[j]]),3)))}
for(j in 1:3){hist(T2$time[[j]], main = paste0(names(T2$time)[j], " --- mean =", round(mean(T2$time[[j]]),3)))}

g <- function(x){round(c(mean = mean(x), sd = sd(x), me = median(x), Q1 = quantile(x, 0.25), Q2 = quantile(x, 0.75)),2)}
sapply(S1$time, g)
sapply(T1$time, g)
sapply(S2$time, g)
sapply(T2$time, g)

#################################################################################################
#################################################################################################
#################################################################################################

